<?php

namespace App\Http\Controllers\Api\Common;

use App\Classes\Common;
use App\Classes\LangTrans;
use App\Http\Controllers\ApiBaseController;
use Examyou\RestAPI\ApiResponse;
use Examyou\RestAPI\Exceptions\ApiException;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\File;
use Nwidart\Modules\Facades\Module;
use Illuminate\Support\Facades\Http;
use GuzzleHttp\Client;
use Illuminate\Support\Arr;

class ModuleController extends ApiBaseController
{
    public function index()
    {
        $modulesData = Common::moduleInformations();

        return ApiResponse::make('Data fetched', $modulesData);
    }

    public function updateStatus(Request $request)
    {
        $moduleName = $request->verified_name;
        $checked = $request->checked;

        if (env('APP_ENV') == 'production' && $checked == false) {
            throw new ApiException('Not Allowed In Demo Mode');
        }

        $module = Module::find($moduleName);

        if ($checked) {
            $module->enable();

            Artisan::call('module:migrate', ['module' => $moduleName, '--force' => true]);
        } else {
            $module->disable();
        }

        $modulesData = Common::moduleInformations();

        return ApiResponse::make('Success', $modulesData);
    }

    public function install(Request $request)
    {
        $response = Http::post('https://envato.codeifly.com/install', [
            'verified_name' => $request->verified_name,
            'domain' => $request->domain,
        ]);

        $responseData = $response->object();

        $tempPath = storage_path() . '/app';
        $fileName = $request->verified_name . '.zip';
        $tempFileName = $tempPath . '/' . $fileName;

        $fileHandler = fopen($tempFileName, 'w');

        $fileUrl = $responseData->url;

        $client = new Client();
        $client->request('GET', $fileUrl,  [
            'sink' => $fileHandler,
            'progress' => function ($downloadTotalSize, $downloadTotalSoFar, $uploadTotalSize, $uploadSizeSoFar) {
                $percentageDownloaded = ($downloadTotalSize > 0) ? (($downloadTotalSoFar / $downloadTotalSize) * 100) : 0;
                File::put(public_path() . '/download-percentage.txt', $percentageDownloaded);
            },
            'verify' => false
        ]);

        $modulesData = Common::moduleInformations();

        return ApiResponse::make('Success', $modulesData);
    }

    public function extractZip(Request $request)
    {
        $moduleName = $request->verified_name;

        $tempPath = storage_path() . '/app';
        $fileName = $request->verified_name . '.zip';
        $tempFileName = $tempPath . '/' . $fileName;

        $extractPath = base_path();

        $zip = \Zip::open($tempFileName);
        $zip->extract($extractPath);

        // LangTrans::seedTranslations($moduleName);
        // sleep(3);
        // Artisan::call('module:migrate', ['module' => $moduleName, '--force' => true]);

        $this->configClear();

        // Delete Downloaded File

        $modulesData = Common::moduleInformations();

        return ApiResponse::make('Success', [
            'installed_modules' => $modulesData['installed_modules'],
            'enabled_modules' => Arr::pluck($modulesData['enabled_modules'], 'verified_name'),
            'verified_name' => $moduleName,
            'version'    => $this->getModuleVersion($moduleName)
        ]);
    }

    public function getModuleVersion($moduleName)
    {
        $module = Module::find($moduleName);

        if ($module) {
            $modulePath = $module->getPath();
            $versionFileName = app_type() == 'saas' ? 'superadmin_version.txt' : 'version.txt';
            $version = File::get($modulePath . '/' . $versionFileName);

            return preg_replace("/\r|\n/", "", $version);
        }

        return "-";
    }

    public function downloadPercent(Request $request)
    {
        $percentage = File::get(public_path() . '/download-percentage.txt');

        return ApiResponse::make('Success', [
            'percentage' => $percentage
        ]);
    }

    public function configClear()
    {
        Artisan::call('config:clear');
        Artisan::call('route:clear');
        Artisan::call('view:clear');
        Artisan::call('cache:clear');
    }
}
